<?php

namespace App\Http\Controllers;

use App\Models\Arsip;
use App\Models\ActivityLog;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        // =========================
        // DASHBOARD ADMIN
        // =========================
       // Grafik (jumlah arsip per tahun)
        $data = Arsip::selectRaw('kurun_waktu, COUNT(*) as total')
            ->groupBy('kurun_waktu')
            ->orderBy('kurun_waktu')
            ->get();

        return view('admin.dashboard', [
            'tahun' => $data->pluck('kurun_waktu'),
            'jumlah' => $data->pluck('total'),
            'totalArsip' => Arsip::count(),
            'pengunjungHariIni' => \App\Models\ActivityLog::whereDate('created_at', now())->count(),
        ]);

        // =========================
        // DASHBOARD USER
        // =========================
        $data = Arsip::selectRaw('kurun_waktu, COUNT(*) as total')
            ->groupBy('kurun_waktu')
            ->orderBy('kurun_waktu')
            ->get();

        return view('user.dashboard', [
            'tahun' => $data->pluck('kurun_waktu'),
            'jumlah' => $data->pluck('total'),
            'totalArsip' => Arsip::count(),
            'pengunjungHariIni' => ActivityLog::whereDate('created_at', now())->count()
        ]);
    }
}
