<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    public function index()
    {
        $users = User::orderBy('name')->get();
        return view('admin.users.index', compact('users'));
    }

    public function create()
    {
        return view('admin.users.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name'     => 'required',
            'username' => 'required|unique:users',
            'email'    => 'required|email|unique:users',
            'role'     => 'required',
            'password' => 'required|min:6|confirmed'
        ]);

        User::create([
            'name'     => $request->name,
            'username' => $request->username,
            'email'    => $request->email,
            'role'     => $request->role,
            'password' => Hash::make($request->password)
        ]);

        return redirect('/users')->with('success', 'User berhasil ditambahkan');
    }

    public function edit($id)
    {
        $user = User::findOrFail($id);
        return view('admin.users.edit', compact('user'));
    }

public function update(Request $request, $id)
{
    $request->validate([
        'name'     => 'required',
        'username' => 'required|unique:users,username,' . $id,
        'role'     => 'required',
        'password' => 'nullable|min:6|confirmed'
    ]);

    $data = [
        'name'     => $request->name,
        'username' => $request->username,
        'role'     => $request->role
    ];

    // Jika password diisi
    if ($request->filled('password')) {
        $data['password'] = Hash::make($request->password);
    }

    User::where('id', $id)->update($data);

    return redirect('/users')->with('success', 'User berhasil diperbarui');
}


    public function destroy($id)
    {
        User::destroy($id);
        return back()->with('success', 'User berhasil dihapus');
    }
}
