<?php

namespace App\Observers;

use App\Models\Arsip;
use App\Models\ActivityLog;

class ArsipObserver
{
    public function created(Arsip $arsip)
    {
        ActivityLog::create([
            'user_id' => auth()->id(),
            'aktivitas' => auth()->user()->username . ' menambahkan arsip: ' . $arsip->uraian,
            'ip_address' => request()->ip()
        ]);
    }

    public function updated(Arsip $arsip)
    {
        ActivityLog::create([
            'user_id' => auth()->id(),
            'aktivitas' => auth()->user()->username . ' memperbarui arsip: ' . $arsip->uraian,
            'ip_address' => request()->ip()
        ]);
    }

    public function deleted(Arsip $arsip)
    {
        ActivityLog::create([
            'user_id' => auth()->id(),
            'aktivitas' => auth()->user()->username . ' menghapus arsip: ' . $arsip->uraian,
            'ip_address' => request()->ip()
        ]);
    }
}
