<?php
namespace App\Observers;

use App\Models\User;
use App\Models\ActivityLog;

class UserObserver
{
    public function created(User $user)
    {
        ActivityLog::create([
            'user_id' => auth()->id(),
            'aktivitas' => 'Admin menambahkan user: ' . $user->username,
            'ip_address' => request()->ip()
        ]);
    }

    public function updated(User $user)
    {
        ActivityLog::create([
            'user_id' => auth()->id(),
            'aktivitas' => 'Admin mengubah data user: ' . $user->username,
            'ip_address' => request()->ip()
        ]);
    }

    public function deleted(User $user)
    {
        ActivityLog::create([
            'user_id' => auth()->id(),
            'aktivitas' => 'Admin menghapus user: ' . $user->username,
            'ip_address' => request()->ip()
        ]);
    }
}
