<?php

namespace App\Providers;

use App\Models\ActivityLog;
use Illuminate\Auth\Events\Login;
use Illuminate\Auth\Events\Logout;
use Illuminate\Auth\Events\Failed;
use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * Event listener mapping (WAJIB di dalam class)
     */
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
    ];

    /**
     * Boot event listeners
     */
    public function boot(): void
    {
        parent::boot();

        // LOGIN BERHASIL
        \Event::listen(Login::class, function ($event) {
            ActivityLog::create([
                'user_id'   => $event->user->id,
                'aktivitas' => $event->user->username . ' login ke sistem',
                'ip_address'=> request()->ip(),
            ]);
        });

        // LOGOUT
        \Event::listen(Logout::class, function ($event) {
            ActivityLog::create([
                'user_id'   => $event->user->id,
                'aktivitas' => $event->user->username . ' logout dari sistem',
                'ip_address'=> request()->ip(),
            ]);
        });

        // LOGIN GAGAL
        \Event::listen(Failed::class, function ($event) {
            ActivityLog::create([
                'user_id'   => null,
                'aktivitas' => ($event->credentials['username'] ?? 'unknown') . ' gagal login',
                'ip_address'=> request()->ip(),
            ]);
        });
    }

    /**
     * Disable auto discovery
     */
    public function shouldDiscoverEvents(): bool
    {
        return false;
    }
}
