<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
{
    Schema::create('arsips', function (Blueprint $table) {
        $table->id();

        $table->string('kode_klasifikasi');
        $table->string('indeks');
        $table->text('uraian');
        $table->year('kurun_waktu');
        $table->string('tingkat_perkembangan');
        $table->string('jumlah');
        $table->string('keterangan')->nullable();
        $table->string('nomor_definitif');
        $table->string('nomor_boks');
        $table->string('lokasi_simpan');

        $table->enum('status', ['aktif','inaktif','terhapus'])->default('aktif');

        $table->timestamps();
    });
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('arsips');
    }
};
