<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Arsip;

class ArsipSeeder extends Seeder
{
    public function run(): void
    {
        $klasifikasi = [
            '400.10.5.1', '400.10.5.2', '400.10.6.1',
            '500.01.2.1', '600.02.3.4'
        ];

        $indeks = ['Laporan', 'Notulen', 'Kajian', 'Dokumentasi', 'Evaluasi'];

        $tingkat = ['Asli, Baik', 'Salinan', 'Asli, Rusak Ringan'];

        $lokasi = ['Lantai 1', 'Lantai 2', 'Lantai 3'];

        $status = ['aktif', 'inaktif', 'terhapus'];

        for ($i = 1; $i <= 2000; $i++) {
            Arsip::create([
                'kode_klasifikasi'      => $klasifikasi[array_rand($klasifikasi)],
                'indeks'                => $indeks[array_rand($indeks)],
                'uraian'                => 'Dokumen Arsip Kegiatan Perencanaan Pembangunan ke-' . $i,
                'kurun_waktu'           => rand(2010, 2025),
                'tingkat_perkembangan'  => $tingkat[array_rand($tingkat)],
                'jumlah'                => rand(1, 5) . ' Berkas',
                'keterangan'            => 'Tekstual',
                'nomor_definitif'       => (string) rand(1, 500),
                'nomor_boks'            => (string) rand(1, 200),
                'lokasi_simpan'         => $lokasi[array_rand($lokasi)],
                'file_pdf' => rand(0,1) 
                    ? 'arsip/sample.pdf' 
                    : null,
                'status'                => $status[array_rand($status)],
            ]);
        }
    }
}
