

@extends('layouts.app')

@section('title', 'Arsip Aktif')

@section('content')
<form method="GET" class="row g-2 mb-3">
    <div class="col-auto">
        <input type="number" name="tahun_awal" class="form-control form-control-sm"
               placeholder="Tahun awal" value="{{ request('tahun_awal') }}">
    </div>
    <div class="col-auto">
        <input type="number" name="tahun_akhir" class="form-control form-control-sm"
               placeholder="Tahun akhir" value="{{ request('tahun_akhir') }}">
    </div>
    <div class="col-auto">
        <button class="btn btn-secondary btn-sm">Terapkan</button>
    </div>

    <div class="col-auto">
        <button name="print" value="true" class="btn btn-outline-dark btn-sm" title="Cetak">
            🖨
        </button>
    </div>

    <div class="col text-end">
        <a href="/arsip/create" class="btn btn-primary btn-sm">Tambah</a>
    </div>

<div class="table-responsive">
<table class="table table-bordered table-striped table-sm">
    <thead class="table-secondary text-center">
        <tr>
            <th>No</th>
            <th>
                Kode Klasifikasi
                <input type="text" name="kode"
                       class="form-control form-control-sm"
                       value="{{ request('kode') }}">
            </th>
            <th>
                Indeks
                <input type="text" name="indeks"
                       class="form-control form-control-sm"
                       value="{{ request('indeks') }}">
            </th>
            <th>
                Uraian
                <input type="text" name="uraian"
                       class="form-control form-control-sm"
                       value="{{ request('uraian') }}">
            </th>
            <th>
                Kurun Waktu
                <input type="number" name="tahun"
                       class="form-control form-control-sm"
                       value="{{ request('tahun') }}">
            </th>
            <th>Tingkat Perkembangan</th>
            <th>Jumlah</th>
            <th>Ket.</th>
            <th>No. Definitif</th>
            <th>No. Boks</th>
            <th>Lokasi Simpan</th>
            <th>Lihat File</th>
            <th>Aksi</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($arsips as $i => $arsip)
        <tr>
            <td class="text-center">{{ $arsips->firstItem() + $i }}</td>
            <td>{{ $arsip->kode_klasifikasi }}</td>
            <td>{{ $arsip->indeks }}</td>
            <td>{{ $arsip->uraian }}</td>
            <td class="text-center">{{ $arsip->kurun_waktu }}</td>
            <td>{{ $arsip->tingkat_perkembangan }}</td>
            <td>{{ $arsip->jumlah }}</td>
            <td>{{ $arsip->keterangan }}</td>
            <td class="text-center">{{ $arsip->nomor_definitif }}</td>
            <td class="text-center">{{ $arsip->nomor_boks }}</td>
            <td>{{ $arsip->lokasi_simpan }}</td>

<td class="text-center">
@php
    $filePath = $arsip->file_pdf
        ? public_path($arsip->file_pdf)
        : null;
@endphp

@if ($filePath && file_exists($filePath))
<a href="{{ route('arsip.lihatFile', $arsip->id) }}"
   target="_blank"
   class="btn btn-outline-danger btn-sm"
   data-bs-toggle="tooltip"
   title="Lihat File">
    <i class="bi bi-file-earmark-pdf-fill"></i>
</a>

@else
    <span class="text-muted">-</span>
@endif
</td>




           <td class="text-center">
            <div class="d-grid gap-1">
                <a href="/arsip/{{ $arsip->id }}/edit" class="btn btn-warning btn-sm">✏</a>
                <form action="/arsip/{{ $arsip->id }}/inaktif" method="POST">
                    @csrf
                    @method('PUT')
                    <button class="btn btn-info btn-sm w-100" title="Pindahkan ke Inaktif">
                        ➜
                    </button>
                </form>

                <form action="/arsip/{{ $arsip->id }}/hapus"
                      method="POST"
                      onsubmit="return confirm('Pindahkan arsip ke terhapus?')">
                    @csrf
                    @method('PUT')
                    <button class="btn btn-danger btn-sm w-100" title="Pindahkan ke Terhapus">
                        🗑
                    </button>
                </form>
            </div>
        </td>
        </tr>
        @endforeach
    </tbody>
</table>
</div>
<div class="d-flex justify-content-center mt-3">
    {{ $arsips->onEachSide(1)->links('pagination::bootstrap-5') }}
</div>
</form>
@endsection
