@extends('layouts.app')
@section('title', 'Tambah Arsip')

@section('content')

<h5 class="mb-3">Tambah Arsip</h5>

@if ($errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form action="/arsip" method="POST" enctype="multipart/form-data">
@csrf

<div class="row g-3">

    <div class="col-md-6">
        <label class="form-label">Kode Klasifikasi</label>
        <input type="text" name="kode_klasifikasi" class="form-control" required>
    </div>

    <div class="col-md-6">
        <label class="form-label">Indeks</label>
        <input type="text" name="indeks" class="form-control" required>
    </div>

    <div class="col-md-12">
        <label class="form-label">Uraian</label>
        <textarea name="uraian" class="form-control" rows="3" required></textarea>
    </div>

    <div class="col-md-4">
        <label class="form-label">Kurun Waktu (Tahun)</label>
        <input type="number" name="kurun_waktu" class="form-control" required>
    </div>

    <div class="col-md-4">
        <label class="form-label">Tingkat Perkembangan</label>
        <input type="text" name="tingkat_perkembangan" class="form-control" required>
    </div>

    <div class="col-md-4">
        <label class="form-label">Jumlah</label>
        <input type="text" name="jumlah" class="form-control" required>
    </div>

    <div class="col-md-6">
        <label class="form-label">Nomor Definitif</label>
        <input type="text" name="nomor_definitif" class="form-control" required>
    </div>

    <div class="col-md-6">
        <label class="form-label">Nomor Boks</label>
        <input type="text" name="nomor_boks" class="form-control" required>
    </div>

    <div class="col-md-12">
        <label class="form-label">Lokasi Simpan</label>
        <input type="text" name="lokasi_simpan" class="form-control" required>
    </div>

    <div class="col-md-12">
        <label class="form-label">Keterangan</label>
        <input type="text" name="keterangan" class="form-control">
    </div>

    <div class="col-md-12">
        <label class="form-label">File PDF (opsional)</label>
        <input type="file" name="file_pdf" class="form-control">
    </div>

</div>

<div class="mt-4">
    <button class="btn btn-primary">Simpan</button>
    <a href="/arsip/aktif" class="btn btn-secondary">Kembali</a>
</div>

</form>
@endsection
