@extends('layouts.app')
@section('title', 'Edit Arsip')

@section('content')

<h5 class="mb-3">Edit Arsip</h5>

@if (session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif

<form action="/arsip/{{ $arsip->id }}" method="POST" enctype="multipart/form-data">
@csrf
@method('PUT')

<div class="row g-3">

    <div class="col-md-6">
        <label class="form-label">Kode Klasifikasi</label>
        <input type="text" name="kode_klasifikasi" class="form-control"
               value="{{ old('kode_klasifikasi', $arsip->kode_klasifikasi) }}" required>
    </div>

    <div class="col-md-6">
        <label class="form-label">Indeks</label>
        <input type="text" name="indeks" class="form-control"
               value="{{ old('indeks', $arsip->indeks) }}" required>
    </div>

    <div class="col-md-12">
        <label class="form-label">Uraian</label>
        <textarea name="uraian" class="form-control" rows="3" required>{{ old('uraian', $arsip->uraian) }}</textarea>
    </div>

    <div class="col-md-4">
        <label class="form-label">Kurun Waktu (Tahun)</label>
        <input type="number" name="kurun_waktu" class="form-control"
               value="{{ old('kurun_waktu', $arsip->kurun_waktu) }}" required>
    </div>

    <div class="col-md-4">
        <label class="form-label">Tingkat Perkembangan</label>
        <input type="text" name="tingkat_perkembangan" class="form-control"
               value="{{ old('tingkat_perkembangan', $arsip->tingkat_perkembangan) }}" required>
    </div>

    <div class="col-md-4">
        <label class="form-label">Jumlah</label>
        <input type="text" name="jumlah" class="form-control"
               value="{{ old('jumlah', $arsip->jumlah) }}" required>
    </div>

    <div class="col-md-6">
        <label class="form-label">Nomor Definitif</label>
        <input type="text" name="nomor_definitif" class="form-control"
               value="{{ old('nomor_definitif', $arsip->nomor_definitif) }}" required>
    </div>

    <div class="col-md-6">
        <label class="form-label">Nomor Boks</label>
        <input type="text" name="nomor_boks" class="form-control"
               value="{{ old('nomor_boks', $arsip->nomor_boks) }}" required>
    </div>

    <div class="col-md-12">
        <label class="form-label">Lokasi Simpan</label>
        <input type="text" name="lokasi_simpan" class="form-control"
               value="{{ old('lokasi_simpan', $arsip->lokasi_simpan) }}" required>
    </div>

    <div class="col-md-12">
        <label class="form-label">Keterangan</label>
        <input type="text" name="keterangan" class="form-control"
               value="{{ old('keterangan', $arsip->keterangan) }}">
    </div>

    <div class="col-md-12">
        <label class="form-label">File PDF</label>
        <input type="file" name="file_pdf" class="form-control">

        @if ($arsip->file_pdf)
            <small class="d-block mt-1">
                File saat ini:
                <a href="{{ asset($arsip->file_pdf) }}" target="_blank">Lihat PDF</a>
            </small>
        @endif
    </div>

</div>

<div class="mt-4">
    <button class="btn btn-primary">Simpan Perubahan</button>
    <a href="{{ url()->previous() }}" class="btn btn-secondary">Kembali</a>
</div>

</form>
@endsection
