@extends('layouts.app')

@section('title','Dashboard Admin')

@section('content')
<div class="container-fluid">

    {{-- GRAFIK --}}
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <h6 class="fw-semibold text-center mb-3">
                Grafik Jumlah Data Arsip Tahun {{ $tahun->first() }} – {{ $tahun->last() }}
            </h6>
            <canvas id="grafikArsip" height="120"></canvas>
        </div>
    </div>

    {{-- CARD --}}
    <div class="row g-3">

        <div class="col-md-6">
            <div class="card shadow-sm text-center p-4">
                <div class="mb-2 fs-2 text-primary">
                    <i class="bi bi-folder-fill"></i>
                </div>
                <div class="text-muted">Jumlah Data Arsip</div>
                <h2 class="fw-bold mb-0">{{ $totalArsip }}</h2>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card shadow-sm text-center p-4">
                <div class="mb-2 fs-2 text-success">
                    <i class="bi bi-people-fill"></i>
                </div>
                <div class="text-muted">Pengunjung Hari Ini</div>
                <h2 class="fw-bold mb-0">{{ $pengunjungHariIni }}</h2>
            </div>
        </div>

    </div>

</div>

{{-- CHART JS --}}
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
new Chart(document.getElementById('grafikArsip'), {
    type: 'bar',
    data: {
        labels: {!! json_encode($tahun) !!},
        datasets: [{
            data: {!! json_encode($jumlah) !!},
            backgroundColor: '#6c757d',
            borderRadius: 6
        }]
    },
    options: {
        plugins: {
            legend: { display: false }
        },
        scales: {
            y: { beginAtZero: true }
        }
    }
});
</script>
@endsection
