@extends('layouts.app')

@section('title', 'Log Aktivitas')

@section('content')
<div class="container-fluid">

    {{-- HEADER + FILTER --}}
    <div class="row align-items-end mb-3">
        <div class="col-md-6">
            <h4 class="fw-bold mb-0">Log Aktivitas</h4>
            <small class="text-muted">Monitoring aktivitas pengguna sistem</small>
        </div>

        <div class="col-md-6">
            <form method="GET" class="row g-2 justify-content-end">
                <div class="col-md-5">
                    <select name="user_id" class="form-select form-select-sm">
                        <option value="">Semua User</option>
                        @foreach($users as $user)
                            <option value="{{ $user->id }}"
                                {{ request('user_id') == $user->id ? 'selected' : '' }}>
                                {{ $user->username }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-4">
                    <input type="date"
                           name="tanggal"
                           value="{{ request('tanggal') }}"
                           class="form-control form-control-sm">
                </div>

                <div class="col-md-3 d-grid">
                    <button class="btn btn-secondary btn-sm">
                        Filter
                    </button>
                </div>
            </form>
        </div>
    </div>

    {{-- LIST LOG --}}
    <div class="card shadow-sm">
        <div class="card-body">

            @forelse($logs as $log)
                <div class="border-bottom pb-2 mb-2">
                    <div class="fw-semibold">
                        {{ $log->aktivitas }}
                    </div>
                    <small class="text-muted">
                        {{ $log->created_at->format('d F Y, H:i') }} WIB
                    </small>
                </div>
            @empty
                <div class="text-center text-muted py-4">
                    Tidak ada aktivitas tercatat
                </div>
            @endforelse

        </div>
    </div>
{{-- PAGINATION --}}
<div class="mt-3">
    {{ $logs->onEachSide(1)->links('pagination::bootstrap-5') }}
</div>

</div>
@endsection
