@extends('layouts.app')
@section('title','Tambah User')

@section('content')

<h6 class="mb-3">Tambah User</h6>
@if ($errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form method="POST" action="/users" style="max-width:400px">
@csrf

<div class="mb-2">
    <label>Nama</label>
    <input type="text" name="name" class="form-control" required>
</div>

<div class="mb-2">
    <label>Username</label>
    <input type="text" name="username" class="form-control" required>
</div>

<div class="mb-2">
    <label>Email</label>
    <input type="email" name="email" class="form-control" required>
</div>

<div class="mb-2">
    <label>Password</label>
    <input type="password" name="password" class="form-control" required>
</div>

<div class="mb-3">
    <label>Ulangi Password</label>
    <input type="password" name="password_confirmation"
           class="form-control" required>
</div>

<div class="mb-3">
    <label>Role</label>
    <select name="role" class="form-control">
        <option value="admin">Admin</option>
        <option value="user">User</option>
    </select>
</div>

<button class="btn btn-primary btn-sm">Simpan</button>
<a href="/users" class="btn btn-secondary btn-sm">Kembali</a>

</form>

@endsection
