@extends('layouts.app')
@section('title','Edit User')

@section('content')

<h6 class="mb-3">Edit User</h6>
@if ($errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form method="POST" action="/users/{{ $user->id }}" style="max-width:400px">
@csrf
@method('PUT')

<div class="mb-2">
    <label>Nama</label>
    <input type="text" name="name" class="form-control"
           value="{{ $user->name }}" required>
</div>

<div class="mb-2">
    <label>Username</label>
    <input type="text" name="username" class="form-control"
           value="{{ $user->username }}" required>
</div>

<div class="mb-2">
    <label>Password Baru (opsional)</label>
    <input type="password" name="password" class="form-control">
</div>

<div class="mb-3">
    <label>Ulangi Password</label>
    <input type="password" name="password_confirmation"
           class="form-control">
</div>

<small class="text-muted">
    Kosongkan jika tidak ingin mengubah password
</small>

<div class="mb-3">
    <label>Role</label>
    <select name="role" class="form-control">
        <option value="admin" {{ $user->role=='admin'?'selected':'' }}>Admin</option>
        <option value="user" {{ $user->role=='user'?'selected':'' }}>User</option>
    </select>
</div>

<button class="btn btn-primary btn-sm">Update</button>
<a href="/users" class="btn btn-secondary btn-sm">Kembali</a>

</form>

@endsection
