@extends('layouts.app')

@section('title', 'Data User')

@section('content')
<div class="container-fluid">

    {{-- HEADER --}}
    <div class="row mb-3">
        <div class="col-md-6">
            <h4 class="fw-bold mb-0">Data User</h4>
            <small class="text-muted">Manajemen akun pengguna sistem</small>
        </div>
        <div class="col-md-6 text-end">
            <a href="{{ route('users.create') }}" class="btn btn-primary btn-sm">
                + Tambah User
            </a>
        </div>
    </div>

    {{-- CARD --}}
    <div class="card shadow-sm">
        <div class="card-body">

            <div class="table-responsive">
                <table class="table table-bordered table-hover align-middle">
                    <thead class="table-secondary text-center">
                        <tr>
                            <th width="60">No</th>
                            <th>Nama</th>
                            <th>Username</th>
                            <th width="120">Role</th>
                            <th width="120">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($users as $i => $user)
                        <tr>
                            <td class="text-center">{{ $i + 1 }}</td>
                            <td>{{ strtoupper($user->name) }}</td>
                            <td>{{ $user->username }}</td>
                            <td class="text-center">
                                <span class="badge {{ $user->role === 'admin' ? 'bg-success' : 'bg-secondary' }}">
                                    {{ ucfirst($user->role) }}
                                </span>
                            </td>
                            <td class="text-center">
                                <a href="{{ route('users.edit', $user->id) }}"
                                   class="btn btn-warning btn-sm" title="Edit">
                                    ✏
                                </a>

                                @if(auth()->id() !== $user->id)
                                <form action="{{ route('users.destroy', $user->id) }}"
                                      method="POST" class="d-inline"
                                      onsubmit="return confirm('Hapus user ini?')">
                                    @csrf
                                    @method('DELETE')
                                    <button class="btn btn-danger btn-sm" title="Hapus">
                                        🗑
                                    </button>
                                </form>
                                @endif
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="5" class="text-center text-muted">
                                Belum ada data user
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

        </div>
    </div>

</div>
@endsection
