<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>@yield('title', 'Sistem Pengarsipan Digital')</title>

    {{-- Bootstrap CSS --}}
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('css/theme.css') }}">

    <style>
        body {
            background-color: #f5f6f8;
            overflow-x: hidden;
        }

        /* SIDEBAR */
        .sidebar {
            width: 240px;
            background-color: #6c757d;
            color: #fff;
            position: fixed;
            top: 0;
            bottom: 0;
            left: 0;
            z-index: 1000;
        }

        .sidebar a {
            color: #fff;
            text-decoration: none;
            display: block;
            padding: 8px 12px;
            border-radius: 4px;
        }

        .sidebar a:hover {
            background-color: #5a6268;
        }

        /* TOPBAR */
        .topbar {
            height: 60px;
            background-color: #ffffff;
            border-bottom: 1px solid #dee2e6;
            position: fixed;
            top: 0;
            left: 240px;
            right: 0;
            z-index: 999;
        }

        /* CONTENT */
        .content {
            margin-left: 240px;
            padding: 30px;
            padding-top: 90px; /* ruang untuk topbar */
            width: calc(100% - 240px);
        }
    </style>

    @stack('css')
</head>
<script>
document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach(el => {
        new bootstrap.Tooltip(el);
    });
});
</script>

<body>

{{-- SIDEBAR --}}
<div class="sidebar p-3">
    @include('layouts.sidebar')
</div>

{{-- TOPBAR --}}
<nav class="topbar d-flex align-items-center px-4">
    <div class="ms-auto dropdown">

        @auth
        <a href="#"
           class="d-flex align-items-center gap-2 text-decoration-none dropdown-toggle topbar-user"
           data-bs-toggle="dropdown"
           aria-expanded="false">

            <img
                src="https://ui-avatars.com/api/?name={{ auth()->user()->name }}&background=2A9D8F&color=ffffff"
                class="rounded-circle"
                width="36"
                height="36"
                alt="Profile"
            >

            <span class="fw-semibold">
                {{ auth()->user()->username }}
            </span>
        </a>

        <ul class="dropdown-menu dropdown-menu-end shadow-sm mt-2">
            <li class="px-3 py-2 small text-muted">
                Role: <strong>{{ ucfirst(auth()->user()->role) }}</strong>
            </li>
            <li><hr class="dropdown-divider"></li>
            <li>
                <form action="{{ route('logout') }}" method="POST">
                    @csrf
                    <button type="submit" class="dropdown-item text-danger">
                        🚪 Logout
                    </button>
                </form>
            </li>
        </ul>
        @endauth

    </div>
</nav>



{{-- CONTENT --}}
<div class="content">
    @yield('content')
</div>

{{-- Bootstrap JS --}}
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

@stack('js')

</body>
</html>
