@extends('layouts.app')

@section('title', 'Arsip Aktif')

@section('content')
<div class="container-fluid">

    {{-- HEADER --}}
    <div class="row mb-3 align-items-end">
        <div class="col-md-6">
            <h4 class="fw-bold mb-0">Arsip Aktif</h4>
            <small class="text-muted">Daftar arsip aktif yang dapat diakses pengguna</small>
        </div>
    </div>

    {{-- FILTER (SAMA SEPERTI ADMIN) --}}
    <div class="card shadow-sm mb-3">
        <div class="card-body p-3">
            <form method="GET" class="row g-2">

                <div class="col-md-2">
                    <input type="number" name="tahun_awal"
                           value="{{ request('tahun_awal') }}"
                           class="form-control form-control-sm"
                           placeholder="Tahun awal">
                </div>

                <div class="col-md-2">
                    <input type="number" name="tahun_akhir"
                           value="{{ request('tahun_akhir') }}"
                           class="form-control form-control-sm"
                           placeholder="Tahun akhir">
                </div>

                <div class="col-md-6">
                    <input type="text" name="q"
                           value="{{ request('q') }}"
                           class="form-control form-control-sm"
                           placeholder="Cari kode, indeks, uraian">
                </div>

                <div class="col-md-2 d-grid">
                    <button class="btn btn-secondary btn-sm">Terapkan</button>
                </div>

            </form>
        </div>
    </div>

    {{-- TABLE (STRUKTUR ADMIN, TANPA AKSI) --}}
    <div class="card shadow-sm">
        <div class="card-body table-responsive">

            <table class="table table-bordered table-hover align-middle table-sm">
                <thead class="table-secondary text-center">
                    <tr>
                        <th>No</th>
                        <th>Kode Klasifikasi</th>
                        <th>Indeks</th>
                        <th>Uraian</th>
                        <th>Kurun Waktu</th>
                        <th>Tingkat Perkembangan</th>
                        <th>Jumlah</th>
                        <th>Ket.</th>
                        <th>No. Definitif</th>
                        <th>No. Boks</th>
                        <th>Lokasi Simpan</th>
                        <th width="90">Lihat File</th>
                    </tr>
                </thead>

                <tbody>
                @forelse($arsips as $i => $arsip)
                    <tr>
                        <td class="text-center">{{ $arsips->firstItem() + $i }}</td>
                        <td>{{ $arsip->kode_klasifikasi }}</td>
                        <td>{{ $arsip->indeks }}</td>
                        <td>{{ $arsip->uraian }}</td>
                        <td class="text-center">{{ $arsip->kurun_waktu }}</td>
                        <td class="text-center">{{ $arsip->tingkat_perkembangan }}</td>
                        <td class="text-center">{{ $arsip->jumlah }} Berkas</td>
                        <td class="text-center">{{ $arsip->keterangan }}</td>
                        <td class="text-center">{{ $arsip->nomor_definitif }}</td>
                        <td class="text-center">{{ $arsip->nomor_boks }}</td>
                        <td class="text-center">{{ $arsip->lokasi_simpan }}</td>
                        <td class="text-center">

                            @php
                                $filePath = $arsip->file_pdf
                                    ? public_path($arsip->file_pdf)
                                    : null;
                            @endphp

                            @if ($filePath && file_exists($filePath))
                                <a href="{{ route('arsip.lihatFile', $arsip->id) }}"
                                   target="_blank"
                                   class="btn btn-outline-danger btn-sm"
                                   data-bs-toggle="tooltip"
                                   title="Lihat File">
                                    <i class="bi bi-file-earmark-pdf-fill"></i>
                                </a>
                            @else
                                <span class="text-muted">-</span>
                            @endif

                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="12" class="text-center text-muted">
                            Tidak ada arsip tersedia
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>

        </div>
    </div>

    {{-- PAGINATION --}}
    <div class="mt-3">
        {{ $arsips->onEachSide(1)->links('pagination::bootstrap-5') }}
    </div>

</div>
@endsection
