@extends('layouts.app')

@section('title', 'Dashboard User')

@section('content')
<div class="container-fluid">

    {{-- HEADER --}}
    <div class="mb-4">
        <h4 class="fw-bold mb-1">Dashboard User</h4>
        <small class="text-muted">Ringkasan data arsip sistem</small>
    </div>

    {{-- GRAFIK --}}
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <h6 class="fw-semibold mb-3 text-center">
                Grafik Jumlah Data Arsip Tahun 2010 – 2025
            </h6>

            <canvas id="arsipChart" height="100"></canvas>
        </div>
    </div>

    {{-- INFO CARD --}}
    <div class="row g-3">

        <div class="col-md-6">
            <div class="card shadow-sm border-0 text-center h-100">
                <div class="card-body">
                    <div class="mb-2">
                        <i class="bi bi-folder-fill fs-2 text-primary"></i>
                    </div>
                    <h6 class="text-muted">Jumlah Data Arsip</h6>
                    <h3 class="fw-bold">{{ $totalArsip ?? 0 }}</h3>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card shadow-sm border-0 text-center h-100">
                <div class="card-body">
                    <div class="mb-2">
                        <i class="bi bi-people-fill fs-2 text-success"></i>
                    </div>
                    <h6 class="text-muted">Pengunjung Hari Ini</h6>
                    <h3 class="fw-bold">{{ $pengunjungHariIni ?? 0 }}</h3>
                </div>
            </div>
        </div>

    </div>

</div>
@endsection

@push('js')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
const ctx = document.getElementById('arsipChart');

new Chart(ctx, {
    type: 'bar',
    data: {
        labels: {!! json_encode($tahun ?? []) !!},
        datasets: [{
            label: 'Jumlah Arsip',
            data: {!! json_encode($jumlah ?? []) !!},
            backgroundColor: '#6c757d'
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: {
                display: false
            }
        },
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>
@endpush
