<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;

use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ArsipController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\LogAktivitasController;

/*
|--------------------------------------------------------------------------
| AUTH (Login & Logout)
|--------------------------------------------------------------------------
*/
Route::get('/login', [AuthController::class, 'showLogin'])
    ->name('login');

Route::post('/login', [AuthController::class, 'login'])
    ->name('login.process');

Route::post('/logout', [AuthController::class, 'logout'])
    ->name('logout');

/*
|--------------------------------------------------------------------------
| Redirect Awal
|--------------------------------------------------------------------------
*/
Route::get('/', function () {
    return redirect()->route('dashboard');
});

/*
|--------------------------------------------------------------------------
| ROUTE WAJIB LOGIN
|--------------------------------------------------------------------------
*/
Route::middleware('auth')->group(function () {

    /*
    |--------------------------------------------------------------------------
    | DASHBOARD (ADMIN & USER – dibedakan di controller)
    |--------------------------------------------------------------------------
    */
    Route::get('/dashboard', [DashboardController::class, 'index'])
        ->name('dashboard');

    /*
    |--------------------------------------------------------------------------
    | LIHAT FILE PDF (ADMIN & USER)
    |--------------------------------------------------------------------------
    */
    Route::get('/arsip/{id}/lihat-file', [ArsipController::class, 'lihatFile'])
        ->name('arsip.lihatFile');

    /*
    |--------------------------------------------------------------------------
    | ===================== ADMIN AREA =====================
    |--------------------------------------------------------------------------
    */
    Route::middleware('admin')->group(function () {

        /*
        | LOG AKTIVITAS (ADMIN)
        */
        Route::get('/log-aktivitas', [LogAktivitasController::class, 'index'])
            ->name('log.aktivitas');

        /*
        | DATA USER (CRUD – ADMIN)
        */
        Route::prefix('users')->name('users.')->group(function () {

            Route::get('/', [UserController::class, 'index'])->name('index');
            Route::get('/create', [UserController::class, 'create'])->name('create');
            Route::post('/', [UserController::class, 'store'])->name('store');

            Route::get('/{id}/edit', [UserController::class, 'edit'])->name('edit');
            Route::put('/{id}', [UserController::class, 'update'])->name('update');

            Route::delete('/{id}', [UserController::class, 'destroy'])->name('destroy');
        });

        /*
        | DATA ARSIP (ADMIN FULL ACCESS)
        */
        Route::prefix('arsip')->name('arsip.')->group(function () {

            // Halaman
            Route::get('/aktif', [ArsipController::class, 'aktif'])->name('aktif');
            Route::get('/inaktif', [ArsipController::class, 'inaktif'])->name('inaktif');
            Route::get('/terhapus', [ArsipController::class, 'terhapus'])->name('terhapus');

            // Tambah Arsip
            Route::get('/create', [ArsipController::class, 'create'])->name('create');
            Route::post('/', [ArsipController::class, 'store'])->name('store');

            // Edit Arsip
            Route::get('/{id}/edit', [ArsipController::class, 'edit'])->name('edit');
            Route::put('/{id}', [ArsipController::class, 'update'])->name('update');

            // Aksi Status
            Route::put('/{id}/inaktif', [ArsipController::class, 'inaktifkan'])->name('inaktifkan');
            Route::put('/{id}/aktifkan', [ArsipController::class, 'aktifkan'])->name('aktifkan');
            Route::put('/{id}/hapus', [ArsipController::class, 'hapus'])->name('hapus');
            Route::put('/{id}/pulihkan', [ArsipController::class, 'pulihkan'])->name('pulihkan');
        });

    });

    /*
    |--------------------------------------------------------------------------
    | ===================== USER AREA =====================
    |--------------------------------------------------------------------------
    */
    Route::prefix('user')->name('user.')->middleware('auth')->group(function () {

        Route::get('/arsip-aktif', [ArsipController::class, 'aktifUser'])
            ->name('arsip.aktif');

        Route::get('/arsip-inaktif', [ArsipController::class, 'inaktifUser'])
            ->name('arsip.inaktif');
    });

    // routes/web.php
    Route::middleware('auth')->prefix('user')->name('user.')->group(function () {

        Route::get('/arsip-aktif', [ArsipController::class, 'aktifUser'])
            ->name('arsip.aktif');

        Route::get('/arsip-inaktif', [ArsipController::class, 'inaktifUser'])
            ->name('arsip.inaktif');
    });



});
