<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Login | Sistem Arsip Digital</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
html, body {
    margin: 0;
    padding: 0;
    height: 100%;
    overflow: hidden;
    font-family: 'Segoe UI', sans-serif;
}

/* CANVAS GALAXY */
#galaxy {
    position: fixed;
    inset: 0;
    z-index: 0;
    background: linear-gradient(135deg, #FFE5B4, #CFF5E7);
}

/* LOGIN */
.login-wrapper {
    position: relative;
    z-index: 2;
    height: 100vh;
    display: flex;
    justify-content: center;
    align-items: center;
}

.login-card {
    background: rgba(255,255,255,0.95);
    border-radius: 16px;
    padding: 32px;
    width: 100%;
    max-width: 400px;
    box-shadow: 0 20px 40px rgba(0,0,0,0.25);
}
.btn-login {
    background: linear-gradient(135deg, #F4A261, #2A9D8F);
    border: none;
    border-radius: 10px;
    color: #fff;
    font-weight: 600;
}
</style>
</head>
<body>

<!-- CANVAS -->
<canvas id="galaxy"></canvas>

<!-- LOGIN -->
<div class="login-wrapper">
    <div class="login-card">

        <div class="text-center mb-4">
            <h4 class="fw-bold">Sistem Arsip Digital</h4>
            <small class="text-muted">Silakan login untuk melanjutkan</small>
        </div>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger small">
                <?php echo e($errors->first()); ?>

            </div>
        <?php endif; ?>

        <form method="POST" action="<?php echo e(route('login.process')); ?>">
            <?php echo csrf_field(); ?>
            <div class="mb-3">
                <label class="form-label">Username</label>
                <input name="username" class="form-control" required autofocus>
            </div>
            <div class="mb-4">
                <label class="form-label">Password</label>
                <input type="password" name="password" class="form-control" required>
            </div>
            <button class="btn btn-login w-100 py-2">Login</button>
        </form>

    </div>
</div>

<script>
const canvas = document.getElementById('galaxy');
const ctx = canvas.getContext('2d');

function resize() {
    canvas.width = window.innerWidth;
    canvas.height = window.innerHeight;
}
resize();
window.addEventListener('resize', resize);

let stars = [];
for (let i = 0; i < 200; i++) {
    stars.push({
        x: Math.random() * canvas.width,
        y: Math.random() * canvas.height,
        r: Math.random() * 1.5 + 0.5,
        v: Math.random() * 0.3 + 0.1
    });
}

function animate() {
    ctx.clearRect(0, 0, canvas.width, canvas.height);

    stars.forEach(s => {
        ctx.beginPath();
        ctx.arc(s.x, s.y, s.r, 0, Math.PI * 2);
        ctx.fillStyle = 'rgba(255,255,255,0.9)';
        ctx.fill();

        s.y += s.v;
        if (s.y > canvas.height) s.y = 0;
    });

    requestAnimationFrame(animate);
}
animate();
</script>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\si-arsip\resources\views/auth/login.blade.php ENDPATH**/ ?>