
<?php $__env->startSection('title', 'Edit Arsip'); ?>

<?php $__env->startSection('content'); ?>

<h5 class="mb-3">Edit Arsip</h5>

<?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
<?php endif; ?>

<form action="/arsip/<?php echo e($arsip->id); ?>" method="POST" enctype="multipart/form-data">
<?php echo csrf_field(); ?>
<?php echo method_field('PUT'); ?>

<div class="row g-3">

    <div class="col-md-6">
        <label class="form-label">Kode Klasifikasi</label>
        <input type="text" name="kode_klasifikasi" class="form-control"
               value="<?php echo e(old('kode_klasifikasi', $arsip->kode_klasifikasi)); ?>" required>
    </div>

    <div class="col-md-6">
        <label class="form-label">Indeks</label>
        <input type="text" name="indeks" class="form-control"
               value="<?php echo e(old('indeks', $arsip->indeks)); ?>" required>
    </div>

    <div class="col-md-12">
        <label class="form-label">Uraian</label>
        <textarea name="uraian" class="form-control" rows="3" required><?php echo e(old('uraian', $arsip->uraian)); ?></textarea>
    </div>

    <div class="col-md-4">
        <label class="form-label">Kurun Waktu (Tahun)</label>
        <input type="number" name="kurun_waktu" class="form-control"
               value="<?php echo e(old('kurun_waktu', $arsip->kurun_waktu)); ?>" required>
    </div>

    <div class="col-md-4">
        <label class="form-label">Tingkat Perkembangan</label>
        <input type="text" name="tingkat_perkembangan" class="form-control"
               value="<?php echo e(old('tingkat_perkembangan', $arsip->tingkat_perkembangan)); ?>" required>
    </div>

    <div class="col-md-4">
        <label class="form-label">Jumlah</label>
        <input type="text" name="jumlah" class="form-control"
               value="<?php echo e(old('jumlah', $arsip->jumlah)); ?>" required>
    </div>

    <div class="col-md-6">
        <label class="form-label">Nomor Definitif</label>
        <input type="text" name="nomor_definitif" class="form-control"
               value="<?php echo e(old('nomor_definitif', $arsip->nomor_definitif)); ?>" required>
    </div>

    <div class="col-md-6">
        <label class="form-label">Nomor Boks</label>
        <input type="text" name="nomor_boks" class="form-control"
               value="<?php echo e(old('nomor_boks', $arsip->nomor_boks)); ?>" required>
    </div>

    <div class="col-md-12">
        <label class="form-label">Lokasi Simpan</label>
        <input type="text" name="lokasi_simpan" class="form-control"
               value="<?php echo e(old('lokasi_simpan', $arsip->lokasi_simpan)); ?>" required>
    </div>

    <div class="col-md-12">
        <label class="form-label">Keterangan</label>
        <input type="text" name="keterangan" class="form-control"
               value="<?php echo e(old('keterangan', $arsip->keterangan)); ?>">
    </div>

    <div class="col-md-12">
        <label class="form-label">File PDF</label>
        <input type="file" name="file_pdf" class="form-control">

        <?php if($arsip->file_pdf): ?>
            <small class="d-block mt-1">
                File saat ini:
                <a href="<?php echo e(asset($arsip->file_pdf)); ?>" target="_blank">Lihat PDF</a>
            </small>
        <?php endif; ?>
    </div>

</div>

<div class="mt-4">
    <button class="btn btn-primary">Simpan Perubahan</button>
    <a href="<?php echo e(url()->previous()); ?>" class="btn btn-secondary">Kembali</a>
</div>

</form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\si-arsip\resources\views/admin/arsip/edit.blade.php ENDPATH**/ ?>