



<?php $__env->startSection('title', 'Arsip Aktif'); ?>

<?php $__env->startSection('content'); ?>
<form method="GET" class="row g-2 mb-3">
    <div class="col-auto">
        <input type="number" name="tahun_awal" class="form-control form-control-sm"
               placeholder="Tahun awal" value="<?php echo e(request('tahun_awal')); ?>">
    </div>
    <div class="col-auto">
        <input type="number" name="tahun_akhir" class="form-control form-control-sm"
               placeholder="Tahun akhir" value="<?php echo e(request('tahun_akhir')); ?>">
    </div>
    <div class="col-auto">
        <button class="btn btn-secondary btn-sm">Terapkan</button>
    </div>

    <div class="col-auto">
        <button name="print" value="true" class="btn btn-outline-dark btn-sm" title="Cetak">
            🖨
        </button>
    </div>

    <div class="col text-end">
        <a href="/arsip/create" class="btn btn-primary btn-sm">Tambah</a>
    </div>

<div class="table-responsive">
<table class="table table-bordered table-striped table-sm">
    <thead class="table-secondary text-center">
        <tr>
            <th>No</th>
            <th>
                Kode Klasifikasi
                <input type="text" name="kode"
                       class="form-control form-control-sm"
                       value="<?php echo e(request('kode')); ?>">
            </th>
            <th>
                Indeks
                <input type="text" name="indeks"
                       class="form-control form-control-sm"
                       value="<?php echo e(request('indeks')); ?>">
            </th>
            <th>
                Uraian
                <input type="text" name="uraian"
                       class="form-control form-control-sm"
                       value="<?php echo e(request('uraian')); ?>">
            </th>
            <th>
                Kurun Waktu
                <input type="number" name="tahun"
                       class="form-control form-control-sm"
                       value="<?php echo e(request('tahun')); ?>">
            </th>
            <th>Tingkat Perkembangan</th>
            <th>Jumlah</th>
            <th>Ket.</th>
            <th>No. Definitif</th>
            <th>No. Boks</th>
            <th>Lokasi Simpan</th>
            <th>Lihat File</th>
            <th>Aksi</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $arsips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $arsip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td class="text-center"><?php echo e($arsips->firstItem() + $i); ?></td>
            <td><?php echo e($arsip->kode_klasifikasi); ?></td>
            <td><?php echo e($arsip->indeks); ?></td>
            <td><?php echo e($arsip->uraian); ?></td>
            <td class="text-center"><?php echo e($arsip->kurun_waktu); ?></td>
            <td><?php echo e($arsip->tingkat_perkembangan); ?></td>
            <td><?php echo e($arsip->jumlah); ?></td>
            <td><?php echo e($arsip->keterangan); ?></td>
            <td class="text-center"><?php echo e($arsip->nomor_definitif); ?></td>
            <td class="text-center"><?php echo e($arsip->nomor_boks); ?></td>
            <td><?php echo e($arsip->lokasi_simpan); ?></td>

<td class="text-center">
<?php
    $filePath = $arsip->file_pdf
        ? public_path($arsip->file_pdf)
        : null;
?>

<?php if($filePath && file_exists($filePath)): ?>
<a href="<?php echo e(route('arsip.lihatFile', $arsip->id)); ?>"
   target="_blank"
   class="btn btn-outline-danger btn-sm"
   data-bs-toggle="tooltip"
   title="Lihat File">
    <i class="bi bi-file-earmark-pdf-fill"></i>
</a>

<?php else: ?>
    <span class="text-muted">-</span>
<?php endif; ?>
</td>




           <td class="text-center">
            <div class="d-grid gap-1">
                <a href="/arsip/<?php echo e($arsip->id); ?>/edit" class="btn btn-warning btn-sm">✏</a>
                <form action="/arsip/<?php echo e($arsip->id); ?>/inaktif" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <button class="btn btn-info btn-sm w-100" title="Pindahkan ke Inaktif">
                        ➜
                    </button>
                </form>

                <form action="/arsip/<?php echo e($arsip->id); ?>/hapus"
                      method="POST"
                      onsubmit="return confirm('Pindahkan arsip ke terhapus?')">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <button class="btn btn-danger btn-sm w-100" title="Pindahkan ke Terhapus">
                        🗑
                    </button>
                </form>
            </div>
        </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
</div>
<div class="d-flex justify-content-center mt-3">
    <?php echo e($arsips->onEachSide(1)->links('pagination::bootstrap-5')); ?>

</div>
</form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\si-arsip\resources\views/admin/arsip/aktif.blade.php ENDPATH**/ ?>