

<?php $__env->startSection('title', 'Arsip Aktif'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    
    <div class="row mb-3 align-items-end">
        <div class="col-md-6">
            <h4 class="fw-bold mb-0">Arsip Aktif</h4>
            <small class="text-muted">Daftar arsip aktif yang dapat diakses pengguna</small>
        </div>
    </div>

    
    <div class="card shadow-sm mb-3">
        <div class="card-body p-3">
            <form method="GET" class="row g-2">

                <div class="col-md-2">
                    <input type="number" name="tahun_awal"
                           value="<?php echo e(request('tahun_awal')); ?>"
                           class="form-control form-control-sm"
                           placeholder="Tahun awal">
                </div>

                <div class="col-md-2">
                    <input type="number" name="tahun_akhir"
                           value="<?php echo e(request('tahun_akhir')); ?>"
                           class="form-control form-control-sm"
                           placeholder="Tahun akhir">
                </div>

                <div class="col-md-6">
                    <input type="text" name="q"
                           value="<?php echo e(request('q')); ?>"
                           class="form-control form-control-sm"
                           placeholder="Cari kode, indeks, uraian">
                </div>

                <div class="col-md-2 d-grid">
                    <button class="btn btn-secondary btn-sm">Terapkan</button>
                </div>

            </form>
        </div>
    </div>

    
    <div class="card shadow-sm">
        <div class="card-body table-responsive">

            <table class="table table-bordered table-hover align-middle table-sm">
                <thead class="table-secondary text-center">
                    <tr>
                        <th>No</th>
                        <th>Kode Klasifikasi</th>
                        <th>Indeks</th>
                        <th>Uraian</th>
                        <th>Kurun Waktu</th>
                        <th>Tingkat Perkembangan</th>
                        <th>Jumlah</th>
                        <th>Ket.</th>
                        <th>No. Definitif</th>
                        <th>No. Boks</th>
                        <th>Lokasi Simpan</th>
                        <th width="90">Lihat File</th>
                    </tr>
                </thead>

                <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $arsips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $arsip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td class="text-center"><?php echo e($arsips->firstItem() + $i); ?></td>
                        <td><?php echo e($arsip->kode_klasifikasi); ?></td>
                        <td><?php echo e($arsip->indeks); ?></td>
                        <td><?php echo e($arsip->uraian); ?></td>
                        <td class="text-center"><?php echo e($arsip->kurun_waktu); ?></td>
                        <td class="text-center"><?php echo e($arsip->tingkat_perkembangan); ?></td>
                        <td class="text-center"><?php echo e($arsip->jumlah); ?> Berkas</td>
                        <td class="text-center"><?php echo e($arsip->keterangan); ?></td>
                        <td class="text-center"><?php echo e($arsip->nomor_definitif); ?></td>
                        <td class="text-center"><?php echo e($arsip->nomor_boks); ?></td>
                        <td class="text-center"><?php echo e($arsip->lokasi_simpan); ?></td>
                        <td class="text-center">

                            <?php
                                $filePath = $arsip->file_pdf
                                    ? public_path($arsip->file_pdf)
                                    : null;
                            ?>

                            <?php if($filePath && file_exists($filePath)): ?>
                                <a href="<?php echo e(route('arsip.lihatFile', $arsip->id)); ?>"
                                   target="_blank"
                                   class="btn btn-outline-danger btn-sm"
                                   data-bs-toggle="tooltip"
                                   title="Lihat File">
                                    <i class="bi bi-file-earmark-pdf-fill"></i>
                                </a>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>

                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="12" class="text-center text-muted">
                            Tidak ada arsip tersedia
                        </td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>

        </div>
    </div>

    
    <div class="mt-3">
        <?php echo e($arsips->onEachSide(1)->links('pagination::bootstrap-5')); ?>

    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\si-arsip\resources\views/user/arsip/aktif.blade.php ENDPATH**/ ?>