

<?php $__env->startSection('title', 'Data User'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    
    <div class="row mb-3">
        <div class="col-md-6">
            <h4 class="fw-bold mb-0">Data User</h4>
            <small class="text-muted">Manajemen akun pengguna sistem</small>
        </div>
        <div class="col-md-6 text-end">
            <a href="<?php echo e(route('users.create')); ?>" class="btn btn-primary btn-sm">
                + Tambah User
            </a>
        </div>
    </div>

    
    <div class="card shadow-sm">
        <div class="card-body">

            <div class="table-responsive">
                <table class="table table-bordered table-hover align-middle">
                    <thead class="table-secondary text-center">
                        <tr>
                            <th width="60">No</th>
                            <th>Nama</th>
                            <th>Username</th>
                            <th width="120">Role</th>
                            <th width="120">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="text-center"><?php echo e($i + 1); ?></td>
                            <td><?php echo e(strtoupper($user->name)); ?></td>
                            <td><?php echo e($user->username); ?></td>
                            <td class="text-center">
                                <span class="badge <?php echo e($user->role === 'admin' ? 'bg-success' : 'bg-secondary'); ?>">
                                    <?php echo e(ucfirst($user->role)); ?>

                                </span>
                            </td>
                            <td class="text-center">
                                <a href="<?php echo e(route('users.edit', $user->id)); ?>"
                                   class="btn btn-warning btn-sm" title="Edit">
                                    ✏
                                </a>

                                <?php if(auth()->id() !== $user->id): ?>
                                <form action="<?php echo e(route('users.destroy', $user->id)); ?>"
                                      method="POST" class="d-inline"
                                      onsubmit="return confirm('Hapus user ini?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button class="btn btn-danger btn-sm" title="Hapus">
                                        🗑
                                    </button>
                                </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="text-center text-muted">
                                Belum ada data user
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\si-arsip\resources\views/admin/users/index.blade.php ENDPATH**/ ?>